// NSW.sc
// oswald berthold, 10/2007
// wetterdaten des national weather service
// im METAR format

// init
(
Server.default = s = Server.local;
s.boot;
g = SwingOSC.default;
g.boot;
)

// codes z.b. mehrere flughaefen um berlin
// tegel EDDT, schoenfeld EDDB, tempelhof EDDI, finowfurt EDAV, potsdam, gatow, jueterbog, dresden, ...

(
SynthDef(\nsw, {
	|temp(0), humid(0), wind(0), winddir(0), p1(100), p2(100), p3(100), p4(100)|
	var sig1 = SinOsc.ar(temp + 30 * 10 + 200, 0, (p1 - 65 / 25).squared, 0);
	var sig2 = SinOsc.ar(temp + 30 * 10 + 200 * 2, 0, (p2 - 65 / 25).squared, 0);
	var sig3 = SinOsc.ar(temp + 30 * 10 + 200 * 3, 0, (p3 - 65 / 25).squared, 0);
	var sig4 = SinOsc.ar(temp + 30 * 10 + 200 * 4, 0, (p4 - 65 / 25).squared, 0);
	Out.ar(0, Mix([sig1, sig2, sig3, sig4]) * EnvGen.ar(Env.perc(0.02, 120, 1, -20), 0.5, timeScale: 1.0, doneAction: 2));
	// ein paar ideen:
	// site code: jeder buchstabe koennte index sein fuer den wavetable eines partialtones, insgesamt also vier pro event
	// temp ist pitch
	// humid ist wetness / hall
	//
}).send(s);
)


(
o = OSCresponder(nil, "/weather", {
	|t,r,m,a|
	[t,r,m].postln;
	
	Synth(\nsw, [\temp, m[2], \p1, m[1].asString[0].ascii, \p2, m[1].asString[1].ascii,
		\p3, m[1].asString[2].ascii, \p4, m[1].asString[3].ascii]);
});
o.add;

n = NetAddr("sloth.mur.at", 5151);
t = Task({
	inf.do {|i|
		"Resending subscribe".postln;
		n.sendMsg("/sub", "/weather"); // eventuell resenden im firewall timeout intervall
		120.wait;
	};
});
t.start;

//t.stop;
)


